*****************************************************************************
* Modulname:	Message Test
* Modultype:	Library
* Dest.Comp.:	HP48
* Language:	System RPL
* Author:	Detlef Mueller, Nibelungenweg 6, 2000 Hamburg 56, W-Germany
* Interface:	MSG1, MSG2, MSG3
* Description:	Test library message handling
* Edition History :
*	0.000	08-25-1991	DM	Alpha version
*****************************************************************************
    TITLE	Message Test
xROMID		329
    ASSEMBLE
MTROMID	EQU	#329
DOMSG	MACRO	* romid,msgnr	** Macro, to handle msg nr. generation **
	CON(5)	=DOBINT
	CON(5)	($1)*256+($2)		* (ROMID << 8) | msgnr *
DOMSG	ENDM
	NIBASC	/HPHP48-E/	** Binary download header **
    RPL
EXTERNAL	xMSG1		** External definitions **
EXTERNAL	xMSG2
EXTERNAL	xMSG3

*** MTLmsg ******************************************************************
* Description :	Message table
*****************************************************************************
    ASSEMBLE
=MTLmsg
    RPL
ARRY
[
    "Memory Lost !?"
    "Achou .."
    "27B-6, 27B-6 ..."
]
*** MTLcfg ******************************************************************
* Interface :	( --> )
* Description :	Attach this library at system warmstart
*****************************************************************************
    ASSEMBLE
=MTLcfg
    RPL
::
    DOBINT MTROMID XEQSETLIB		( *Autoattach* )
;
*** MSG1 ********************************************************************
* Interface :	( --> )
* Description :	Just generate an error with error message 1
*****************************************************************************
    ASSEMBLE
	CON(1)	8			* Tell parser 'Non algebraic' *
    RPL
xNAME	MSG1
::
    CK0
    ASSEMBLE
	DOMSG	MTROMID,1
    RPL
    ERROROUT
;
*** MSG2 ********************************************************************
* Interface :	( --> )
* Description :	Just generate an error with error message 2
*****************************************************************************
    ASSEMBLE
	CON(1)	8
    RPL
xNAME	MSG2
::
    CK0
    ASSEMBLE
	DOMSG	MTROMID,2
    RPL
    ERROROUT
;
*** MSG3 ********************************************************************
* Interface :	( --> )
* Description :	Just generate an error with error message 3
*****************************************************************************

    ASSEMBLE
	CON(1)	8
    RPL
xNAME	MSG3
::
    CK0
    ASSEMBLE
	DOMSG	MTROMID,3
    RPL
    ERROROUT
;
